/*
 * Examples  : Arduino Experiment Examples By....ETT CO.,LTD
 * Program   : ECU CAN-OBDII Interface Demo
 * Hardware  : ET-EASY MEGA1280(DUINO MEGA)
 *           : ET-MINI SPI CAN CONTROL V1.0
 *           : SS#(PB0)  = Digital-53 --> CAN_CS(CS)  
 *           : MISO(PB3) = Digital-50 <-- CAN_MISO(SO)     
 *           : MOSI(PB2) = Digital-51 --> CAN_MOSI(SI)        
 *           : SCK(PB1)  = Digital-52 --> CAN_SCK(SCK)         
 *           : LCD 4 Bit Mode (7 Pin) Interface with Arduino  
 *           : Pin1  = GND = GND                              
 *           : Pin2  = VCC = +5V                              
 *           : Pin3  = VO  = Contrast Adjust Voltage          
 *           : Pin4  = RS  = Digital Pin[0..13] For RS Pin    
 *           : Pin5  = RW  = Digital Pin[0..13] For RW Pin                               
 *           : Pin6  = EN  = Digital Pin[0..13] For EN_Pin    
 *           : Pin7  = D0  = GND                              
 *           : Pin8  = D1  = GND                              
 *           : Pin9  = D2  = GND                              
 *           : Pin10 = D3  = GND                              
 *           : Pin11 = D4  = Digital Pin[0..13] For D4 Pin    
 *           : Pin12 = D4  = Digital Pin[0..13] For D5 Pin    
 *           : Pin13 = D6  = Digital Pin[0..13] For D6 Pin    
 *           : Pin14 = D7  = Digital Pin[0..13] For D7 Pin    
 * Function  : LCD 4 Bit : 7 Pin Interface
 */

#include <mini_spi_can.h>                  // ET-MINI SPI CAN Control
#include <LCD_4BIT.h>                      // Used ETT LCD_4BIT Library

// Assign Arduino Pin For Connect With LCD
// 10Pin D[22-D29]:PA[0..7]
#define LCD_BL   22  //PA0
#define LCD_RS   23  //PA1  
#define LCD_RW   24  //PA2
#define LCD_EN   25  //PA3
#define LCD_D4   26  //PA4
#define LCD_D5   27  //PA5
#define LCD_D6   28  //PA6
#define LCD_D7   29  //PA7

char buffer[32];     //Data will be temporarily stored to this buffer before being written to the file

int LED1 = 13;       //PB7(D13)  

//Create object to Control LCD.  
LCD_4BIT lcd = LCD_4BIT(LCD_RS, LCD_RW, LCD_EN, LCD_D4, LCD_D5, LCD_D6, LCD_D7);    // Used R/W Pin (7 Pin)

void setup() 
{
  pinMode(LED1, OUTPUT); 
  digitalWrite(LED1, HIGH);
  
  lcd.Initial();                                                                    // Initial LCD
  pinMode(LCD_BL, OUTPUT);                                                          //Backlight LED = Output        
  digitalWrite(LCD_BL, HIGH);                                                       //ON Backlight  
  
  Serial.begin(9600);
  Serial.println();
  Serial.println();
  Serial.println("OBDII CAN Reader");
  Serial.println("BY..ETT CO.,LTD.");
  
  lcd.ClearScreen();
  lcd.SetCursor(0x00);
  lcd.Print("OBDII CAN Reader");
  lcd.SetCursor(0x40);
  lcd.Print("BY..ETT CO.,LTD.");

  if(mini_spi_can.init(CAN_500kbps))  /* Initialise MCP2515 CAN controller at the specified speed */
  {    
    lcd.SetCursor(0x40);
    lcd.Print("**Initial Pass**");
    
    Serial.print("**Initial Pass**");
  } 
  else
  {    
    lcd.SetCursor(0x40);
    lcd.Print("**Initial Fail**");
    
    Serial.print("**Initial Fail**");
  } 
}
 
//Read & Display OBDII Result on Character LCD 16x2
//[x][x][x][x][ ][r][p][m] [ ][x][x][k][m][ ][ ][ ]
//[x][x][d][e][g][C][ ][ ] [x][x][g][/][s][ ][ ][ ]

/* Details from http://en.wikipedia.org/wiki/OBD-II_PIDs */
//OBDII CAN Code
//ENGINE_COOLANT_TEMP 0x05  //Engine coolant temperature
//ENGINE_RPM          0x0C  //Engine RPM
//VEHICLE_SPEED       0x0D  //Vehicle speed
//MAF_SENSOR          0x10  //MAF air flow rate
//O2_VOLTAGE          0x14  //Bank 1, Sensor 1:
                            //->Oxygen sensor voltage
                            //->Short term fuel trim
//THROTTLE	      0x11  //Throttle position

void loop() 
{    
  digitalWrite(LED1, HIGH);
  
  //Engine RPM
  if(mini_spi_can.ecu_req(ENGINE_RPM,buffer) == 1)      
  {   
    lcd.SetCursor(0x00);
    lcd.Print("        ");
    lcd.SetCursor(0x00);
    lcd.Print(buffer);
    
    Serial.print("Engine RPM : ");
    Serial.println(buffer);
  } 
  
  //Vehicle speed 
  if(mini_spi_can.ecu_req(VEHICLE_SPEED,buffer) == 1)
  {
    lcd.SetCursor(0x08);
    lcd.Print("        ");
    lcd.SetCursor(0x09);
    lcd.Print(buffer);
    
    Serial.print("Vehicle speed : ");
    Serial.println(buffer);
  }
  
  //Engine coolant temperature
  if(mini_spi_can.ecu_req(ENGINE_COOLANT_TEMP,buffer) == 1)
  {
    lcd.SetCursor(0x40);
    lcd.Print("        ");
    lcd.SetCursor(0x40);
    lcd.Print(buffer);
    
    Serial.print("Engine coolant temperature : ");
    Serial.println(buffer);
  }
  
  //Throttle position
  if(mini_spi_can.ecu_req(THROTTLE,buffer) == 1)
  {    
    lcd.SetCursor(0x48);
    lcd.Print("        ");
    lcd.SetCursor(0x49);
    lcd.Print(buffer);
    
    Serial.print("Throttle Position : ");
    Serial.println(buffer);
  }  
      
  digitalWrite(LED1, LOW); 
  delay(500); 
}

